﻿CREATE TABLE [dbo].[Content](
	[Id] [uniqueidentifier] NOT NULL,
	[ContentType] [nvarchar](256) NOT NULL,
	[Title] [nvarchar](max) NOT NULL,
	[Value] [nvarchar](max) NOT NULL,
	[Shared] [bit] NOT NULL,
 CONSTRAINT [PK_Content] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]



/****** Object:  Table [dbo].[ContentAudience]    Script Date: 10-12-2015 10:21:34 ******/
SET ANSI_NULLS ON


SET QUOTED_IDENTIFIER ON


CREATE TABLE [dbo].[ContentAudience](
	[ContentId] [uniqueidentifier] NOT NULL,
	[PrincipalId] [int] NOT NULL,
	[ContextView] [uniqueidentifier] NOT NULL,
 CONSTRAINT [PK_ContentAudience] PRIMARY KEY CLUSTERED 
(
	[ContentId] ASC,
	[PrincipalId] ASC,
	[ContextView] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[ContentParentChildRelations]    Script Date: 10-12-2015 10:21:34 ******/
SET ANSI_NULLS ON


SET QUOTED_IDENTIFIER ON


CREATE TABLE [dbo].[ContentParentChildRelations](
	[ParentId] [uniqueidentifier] NOT NULL,
	[ChildId] [uniqueidentifier] NOT NULL,
	[SortOrder] [int] NOT NULL,
 CONSTRAINT [PK_ContentParentChildRelations] PRIMARY KEY CLUSTERED 
(
	[ParentId] ASC,
	[ChildId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]



/****** Object:  Table [dbo].[ContentTranslation]    Script Date: 10-12-2015 10:21:34 ******/
SET ANSI_NULLS ON


SET QUOTED_IDENTIFIER ON


CREATE TABLE [dbo].[ContentTranslation](
	[ContentId] [uniqueidentifier] NOT NULL,
	[Language] [nvarchar](50) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
	[Value] [nvarchar](max) NOT NULL,
 CONSTRAINT [PK_ContentTranslation] PRIMARY KEY CLUSTERED 
(
	[ContentId] ASC,
	[Language] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]



ALTER TABLE [dbo].[ContentAudience]  WITH CHECK ADD  CONSTRAINT [FK_ContentAudience_Content] FOREIGN KEY([ContentId])
REFERENCES [dbo].[Content] ([Id])


ALTER TABLE [dbo].[ContentAudience] CHECK CONSTRAINT [FK_ContentAudience_Content]


ALTER TABLE [dbo].[ContentParentChildRelations]  WITH CHECK ADD  CONSTRAINT [FK_ContentParentChildRelations_Content] FOREIGN KEY([ParentId])
REFERENCES [dbo].[Content] ([Id])


ALTER TABLE [dbo].[ContentParentChildRelations] CHECK CONSTRAINT [FK_ContentParentChildRelations_Content]


ALTER TABLE [dbo].[ContentParentChildRelations]  WITH CHECK ADD  CONSTRAINT [FK_ContentParentChildRelations_Content1] FOREIGN KEY([ChildId])
REFERENCES [dbo].[Content] ([Id])


ALTER TABLE [dbo].[ContentParentChildRelations] CHECK CONSTRAINT [FK_ContentParentChildRelations_Content1]


ALTER TABLE [dbo].[ContentTranslation]  WITH CHECK ADD  CONSTRAINT [FK_ContentTranslation_Content] FOREIGN KEY([ContentId])
REFERENCES [dbo].[Content] ([Id])


ALTER TABLE [dbo].[ContentTranslation] CHECK CONSTRAINT [FK_ContentTranslation_Content]